const pewModule = require('./pew_module');
const path = require("path");
const pew = new pewModule.pewModule();
const express = require('express');
const app = express();
const cors = require('cors');
const https = require("https");
const fs = require("fs");
const DEBUG = false;
let port;
let httpsServer;

if (!DEBUG) {
    const certificate = fs.readFileSync('/etc/ssl/certs/ssl-cert-os.pem', 'utf8');
    const privateKey = fs.readFileSync('/etc/ssl/private/ssl-cert-os.key', 'utf8');
    const credentials = { key: privateKey, cert: certificate };
    httpsServer = https.createServer(credentials, app);
    port = parseInt(process.argv[2]);

}
else {
    port = 2000;
}

let listenIP = pew.Constants.ALL_IP;

//Catch exceptions
process.on('uncaughtException', function (err)
{
    try 
    {
        pew.Constants.DebugLog("Uncaught exception: " + err.stack)
    }
    catch (ex) { }
})
app.use(express.json())

//Check if http server is active
pew.getConfFile(pew.Constants.requests.READ_API).then(config => {
    if (config.http_server) {
        app.use(express.static(path.join(__dirname, pew.Constants.configSubfolders.http_server)));
    }

    if (config.use_cors) {
        app.use(cors());
    }

    if (config.ip1 === pew.Constants.LOCAL_HOST && config.ip2 === pew.Constants.LOCAL_HOST) {
        listenIP = pew.Constants.LOCAL_HOST;
    }

    if (config.api_enable) {
        //Set up post for plc api calls
        app.get(pew.Constants.requests.API_TEST, function (_req, res) {
            let result = {
                err: false,
                msg: pew.Constants.API_TEST_SUCCESS
            };
            res.setHeader('Content-Type', 'application/json');
            res.end(JSON.stringify(result));
        })

        app.get(pew.Constants.requests.PLC_GET, function (req, res) {
            pew.plcGet(req)
                .then(result => {
                    res.setHeader('Access-Control-Allow-Origin', '*');
                    res.setHeader('Content-Type', 'application/json');
                    res.end(JSON.stringify(result));
                })
                .catch(err => {
                    let result = {
                        err: true,
                        err_msg: err
                    }
                    res.setHeader('Access-Control-Allow-Origin', '*');
                    res.setHeader('Content-Type', 'application/json');
                    res.end(JSON.stringify(result));
                })
        })

        app.post(pew.Constants.requests.PLC_POST, function (req, res) {
            pew.plcPost(req)
                .then(result => {
                    res.setHeader('Content-Type', 'application/json');
                    res.end(JSON.stringify(result));
                })
                .catch(err => {
                    let result = {
                        err: true,
                        err_msg: err
                    }
                    res.setHeader('Content-Type', 'application/json');
                    res.end(JSON.stringify(result));
                })
        })
    }

    if (config.use_encryption) {
        httpsServer.listen(port);
    }
    else {
        app.listen(port, listenIP, function () {
            console.log(`API Node application started at port: ${port}`);
            //Debug information
            pew.Constants.DebugLog(`API Node application started at port: ${port}`);
        })
    }
})
