#!/bin/sh

# Find the name of the script
cd $( dirname $0 )
# Add the config file for TLS if it's not available
SCRIPT_DIR="$( pwd )"
CONFIG="/mnt/data/hmi/pew/deploy/node/config/pew_tls.json"
CONFIG_SQL="/mnt/data/hmi/pew/deploy/node/config/pew_sql.json"
CONFIG_NOSQL="/mnt/data/hmi/pew/deploy/node/config/pew_nosql.json"
CONFIG_API="/mnt/data/hmi/pew/deploy/node/config/pew_api.json"
CONFIGPATH="/mnt/data/hmi/pew/deploy/node/config/http"
if [ ! -d "$CONFIGPATH" ]
then
	mkdir "$CONFIGPATH"
fi

if [ ! -e "$CONFIG_SQL" -a ! -h "$CONFIG_SQL" ]
then
	cp "$SCRIPT_DIR/config_default/pew_sql.json" "$CONFIG_SQL"
fi

if [ ! -e "$CONFIG_NOSQL" -a ! -h "$CONFIG_NOSQL" ]
then
	cp "$SCRIPT_DIR/config_default/pew_nosql.json" "$CONFIG_NOSQL"
fi

if [ ! -e "$CONFIG_API" -a ! -h "$CONFIG_API" ]
then
	cp "$SCRIPT_DIR/config_default/pew_api.json" "$CONFIG_API"
fi

if [ ! -e "$CONFIG" -a ! -h "$CONFIG" ]
then
	cp "$SCRIPT_DIR/config_default/pew_tls.json" "$CONFIG"
fi

cd /mnt/data/hmi/pew/deploy/node
sleep 2
/mnt/data/hmi/pew/deploy/node_v16/bin/node server.js $@
