"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

const FEATURE_ID = {
  SESSIONRECOVERY: 0x01,
  FEDAUTH: 0x02,
  COLUMNENCRYPTION: 0x04,
  GLOBALTRANSACTIONS: 0x05,
  AZURESQLSUPPORT: 0x08,
  UTF8_SUPPORT: 0x0A,
  TERMINATOR: 0xFF
};

function featureExtAckParser(parser, _options, callback) {
  let fedAuth;
  let utf8Support;

  function next() {
    parser.readUInt8(featureId => {
      if (featureId === FEATURE_ID.TERMINATOR) {
        return callback(new _token.FeatureExtAckToken(fedAuth, utf8Support));
      }

      parser.readUInt32LE(featureAckDataLen => {
        parser.readBuffer(featureAckDataLen, featureData => {
          switch (featureId) {
            case FEATURE_ID.FEDAUTH:
              fedAuth = featureData;
              break;

            case FEATURE_ID.UTF8_SUPPORT:
              utf8Support = !!featureData[0];
              break;
          }

          next();
        });
      });
    });
  }

  next();
}

var _default = featureExtAckParser;
exports.default = _default;
module.exports = featureExtAckParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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