"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _moneyn = _interopRequireDefault(require("./moneyn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const SHIFT_LEFT_32 = (1 << 16) * (1 << 16);
const SHIFT_RIGHT_32 = 1 / SHIFT_LEFT_32;
const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x08]);
const Money = {
  id: 0x3C,
  type: 'MONEY',
  name: 'Money',
  declaration: function () {
    return 'money';
  },
  generateTypeInfo: function () {
    return Buffer.from([_moneyn.default.id, 0x08]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value * 10000;
    const buffer = Buffer.alloc(8);
    buffer.writeInt32LE(Math.floor(value * SHIFT_RIGHT_32), 0);
    buffer.writeInt32LE(value & -1, 4);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    return value;
  }
};
var _default = Money;
exports.default = _default;
module.exports = Money;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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