"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _datetimen = _interopRequireDefault(require("./datetimen"));

var _core = require("@js-joda/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EPOCH_DATE = _core.LocalDate.ofYearDay(1900, 1);

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x08]);
const DateTime = {
  id: 0x3D,
  type: 'DATETIME',
  name: 'DateTime',
  declaration: function () {
    return 'datetime';
  },

  generateTypeInfo() {
    return Buffer.from([_datetimen.default.id, 0x08]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value; // Temporary solution. Remove 'any' later.

    let date;

    if (options.useUTC) {
      date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());
    } else {
      date = _core.LocalDate.of(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }

    let days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    let milliseconds, threeHundredthsOfSecond;

    if (options.useUTC) {
      let seconds = value.getUTCHours() * 60 * 60;
      seconds += value.getUTCMinutes() * 60;
      seconds += value.getUTCSeconds();
      milliseconds = seconds * 1000 + value.getUTCMilliseconds();
    } else {
      let seconds = value.getHours() * 60 * 60;
      seconds += value.getMinutes() * 60;
      seconds += value.getSeconds();
      milliseconds = seconds * 1000 + value.getMilliseconds();
    }

    threeHundredthsOfSecond = milliseconds / (3 + 1 / 3);
    threeHundredthsOfSecond = Math.round(threeHundredthsOfSecond); // 25920000 equals one day

    if (threeHundredthsOfSecond === 25920000) {
      days += 1;
      threeHundredthsOfSecond = 0;
    }

    const buffer = Buffer.alloc(8);
    buffer.writeInt32LE(days, 0);
    buffer.writeUInt32LE(threeHundredthsOfSecond, 4);
    yield buffer;
  },
  // TODO: type 'any' needs to be revisited.
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = DateTime;
exports.default = _default;
module.exports = DateTime;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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