#!/bin/sh
# 
# Generates JMUConfig timezones javascript file

TZDATADIR="/usr/share/zoneinfo/posix"

cat << EOF
// *DO NOT MODIFY* - generated by JMUConfig via $0!
var jmuconfig_timezones = [
EOF

cd "${TZDATADIR}" >/dev/null

find . -type f | sort | \
    grep -v ".tab" |   # ignore .tab files
    sed "s/^\.\//'/" |  # remove leading ./
    sed "s/$/',/"       # add final comma

cd - >/dev/null

cat << EOF
];
EOF
