#!/bin/sh -e
#
# Update password hashes in /mnt/factory/shadow

if [ $# -lt 1 ]; then
	echo "Missin arguments."
	echo "Usage: $0 <username>"
	exit 1
fi

FACTORY_MNT="/mnt/factory/"
ETC_MNT="/etc/"
USER=$1

disabled="$(passwd --status "$USER" | awk '/L/{print $1}')"
if [ "$disabled" != "" ]; then
	echo "User already disabled $USER"
	exit 0
fi

mount -o remount,rw "${FACTORY_MNT}"

rm -f "${ETC_MNT}shadow" && cp "${FACTORY_MNT}shadow" "${ETC_MNT}"
rm -f "${ETC_MNT}passwd" && cp "${FACTORY_MNT}passwd" "${ETC_MNT}"
passwd -l $USER
cp "${ETC_MNT}shadow" "${FACTORY_MNT}" && chgrp shadow "${FACTORY_MNT}shadow"
cp "${ETC_MNT}passwd" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}passwd"
ln -sf "${FACTORY_MNT}shadow" "${ETC_MNT}shadow"
ln -sf "${FACTORY_MNT}passwd" "${ETC_MNT}passwd"
sync

mount -o remount,ro "${FACTORY_MNT}"

exit 0
