#!/bin/bash

. /etc/exorint.funcs

LOGBASE_VOLATILE="/var"
LOGBASE_PERSIST="/mnt/data"

if exorint_in_configos; then
    LOGBASE="${LOGBASE_PERSIST}"
else
    LOGBASE="${LOGBASE_VOLATILE}"
fi

LOGDIR="${LOGBASE}/log"
echo "LOGDIR: ${LOGDIR}"

[ -d "${LOGDIR}" ] || exit 1

cd "${LOGBASE}"

# pre: temporarily grab some persistent logs
cp ${LOGBASE_PERSIST}/updateLog* log

# pack up logs
tar hcvzf $1 log/* || exit 2

# post: cleanup temporary logs
rm log/updateLog*

exit 0
