#!/bin/bash

. /etc/exorint.funcs

VNC_SWFLAG_OFFSET=6

cat << EOF
# NOTE: generated by $0

[core]
idle-time=0
require-input=false
repaint-window=100
EOF

# enable VNC server, if enabled
VNC_ENABLED="$(exorint_param 'services\x11vnc\autostart')"
VNC_EEPROM="$(exorint_swflagarea_bit $VNC_SWFLAG_OFFSET)"
[ "${VNC_EEPROM}" = "1" ] && VNC_ENABLED="true"
if [ "${VNC_ENABLED}" = "true" ]; then
        echo "modules=screen-share.so"
fi

# enable 2D acceleration ok kernel 5 if VNC is not enabled (currently not compatible)
KERNEL_MAJOR=$(uname -r | cut -d '.' -f 1)
G2D_ENABLED="$(exorint_param 'options\gpu\enable_g2d')"
if [ $KERNEL_MAJOR -ge 5 -a "${VNC_ENABLED}" != "true" -a "${G2D_ENABLED}" != "false" ]; then
	echo "use-g2d=1"
fi

VNC_ARGS=""
VNC_PORT=$(grep rfbport /etc/x11vnc/x11vnc.conf | awk '{print $2}')
[ -n "$VNC_PORT" ] && VNC_ARGS="$VNC_ARGS --port=$VNC_PORT"
[ -e /etc/x11vnc/x11vnc_f.pw ] && VNC_ARGS="$VNC_ARGS --rfbauth=/tmp/weston-rfbauth"
cat << EOF

[shell]
background-image=
background-color=0xff000000
panel-position=none
locking=false
allow-zap=false
binding-modifier=none
close-animation=none

[libinput]
touchscreen_calibrator=true
calibration_helper=/usr/bin/save-calibration.sh

[keyboard]
vt-switching=false

[input-method]
path=/usr/libexec/exor_keyboard.sh

[screen-share]
command=/usr/bin/weston --backend=vnc-backend.so --shell=fullscreen-shell.so --log=/var/log/weston-vnc.log $VNC_ARGS
EOF
