#!/bin/sh

echo "HMI: booting!" | logger

export TMPDIR=/mnt/.psplash/

# Window manager sanity check
if ( [ -d "/tmp/.X11-unix/" ] && ! ( xdpyinfo &>/dev/null ) ||
     [ -e "$XDG_RUNTIME_DIR/wayland-0" ] && ! ( weston-info &>/dev/null) ); then

	echo "ERROR: Failed to connect to window manager. Rebooting..." || logger
	sync
	reboot -f
fi

# Stop the watchdog
if [ -e /tmp/.wd_default ]; then
    wdctl -s $( cat /tmp/.wd_default )
    rm /tmp/.wd_default
fi
echo V > /dev/watchdog

if [[ -e $TMPDIR/taptap ]] ; then
	while ( (cat $TMPDIR/taptap | grep wait) > /dev/null 2>&1 ) ; do
		echo "HMI: waiting tapttap" | logger
		ping -c 1 -i 0.3 127.0.0.1 > /dev/null 2>&1;
	done

	if [[ -e $TMPDIR/taptap ]] ; then
		echo "HMI: tap tap content: $(cat $TMPDIR/taptap)" | logger
		if ( (cat $TMPDIR/taptap | grep disable-kiosk-tchcalibrate) > /dev/null 2>&1 ) ; then
			# force pointer calibration
			rm -f /etc/pointercal.xinput /etc/udev/rules.d/touch_calibration.rules
			echo "HMI: force pointer calibration" | logger
		fi

		if ( (cat $TMPDIR/taptap | grep disable-kiosk) > /dev/null 2>&1 ) ; then
			# start no-kiosk mode
			echo "HMI: nokiosk mode" | logger
			touch /etc/nokiosk
		fi

		if ( (cat $TMPDIR/taptap | grep device-restore) > /dev/null 2>&1 ) ; then
			# Device restore
			echo "HMI: Restoring device to defaults" | logger

			dbus-send --print-reply --system --dest=com.exor.EPAD "/DeviceRestore" com.exor.EPAD.DeviceRestore.status; sleep 2
			dbus-send --print-reply --system --dest=com.exor.EPAD "/DeviceRestore" com.exor.EPAD.DeviceRestore.restoreDevice

			# Just hang here
			cat
		fi
	fi
else
	# Signal it's too late now to stop the boot
	touch $TMPDIR/disable
fi
