#!/bin/sh

. /etc/profile

[ ! -e "$XDG_RUNTIME_DIR/wayland-0" -o "$1" = "--restore" ] && exit 1

PATH="/usr/bin:$PATH"

if [ ! -e /etc/udev/rules.d/touch_calibration.rules ] ; then

	DEVICE="$( weston-touch-calibrator 2>/dev/null | grep device | head -n1 | cut -d'"' -f2 )"
	[ -n "$DEVICE" ] || exit 0

	TMPDIR=/mnt/.psplash psplash-write "QUIT"

	# The tool will automatically call /usr/bin/save-calibration.sh which in turn will save
	# the calibration parameters in factory partition
	weston-touch-calibrator $DEVICE
fi
