#!/bin/bash
#
set -e
if [ $# -lt 1 ]; then
        echo "Missing arguments."
        echo "Usage: $0 <username>"
        exit 1
fi

FACTORY_MNT="/mnt/factory/"
ETC_MNT="/etc/"
USERNAME="$1"

show_expired()
{
#Maximum number of days between password change
	local USER=$1
	local RESULT=$(chage -l "$USER")
	#echo  "$RESULT"
	local test1=$(echo "$RESULT"| awk -F':' '/Password expires/{ gsub(/^ /, "", $2); print $2}')
	local test2=$(echo "$RESULT"| awk -F':' '/Maximum number of days between password change/{ gsub(/^ /, "", $2); print $2}')
	[ "$test1" == "never" ] && test1="never" && test2=""
	echo $USER $test1 $test2
}

check_expired()
{
	local LINE="$1"
	local a=$(echo "$LINE" | cut -d':' -f1)
        local TYPE="$( echo "$LINE" | cut -d':' -f2 | cut -d'$' -f2 )"
        if [ "$TYPE" != "6" ]; then
                return;
        fi
        if [ "root" == "$a" ] || [ "app" == "$a" ]; then
                return;
        fi
	local output=$(show_expired "$a")
        echo "$output"
}

rm -f "${ETC_MNT}shadow" && cp "${FACTORY_MNT}shadow" "${ETC_MNT}"
rm -f "${ETC_MNT}passwd" && cp "${FACTORY_MNT}passwd" "${ETC_MNT}"

if [ "$USERNAME" == "-list" ]; then
	for LINE in $(cat /etc/shadow)
	do
		check_expired "$LINE"
	done
else
	
	for LINE in $(cat /etc/shadow | grep "^$USERNAME:" || true)
        do
                check_expired "$LINE"
        done
fi

ln -sfb "${FACTORY_MNT}shadow" "${ETC_MNT}shadow"
ln -sfb "${FACTORY_MNT}passwd" "${ETC_MNT}passwd"
sync

exit 0
